(function ($) {

      /* legent font family */
      var ctxFont = "'Quicksand', sans-serif",
          ctxTickColor = '#8896a5',
          months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];



      /* set chart js flobal style */
      Chart.defaults.global.defaultFontFamily = ctxFont;
      Chart.defaults.global.defaultFontColor = "#8896a5";
      Chart.defaults.global.defaultFontSize = 14;



      /* custom legend function */
      function customLegend(chart) {
          var text = [];
          text.push('<ul class="piechart'+ chart.id + '-legend">');
          var data = chart.data;
          var datasets = data.datasets;
          var labels = data.labels;
          if (datasets.length) {
              /*check if the type of the chart is line and take length accordingly for iteration*/
              var dataLength = chart.config.type === "line" ? datasets.length : datasets[0].backgroundColor.length;

              /*set the data source according to type*/
              function getData(i){
                  return (
                      [chart.config.type === "line" ? datasets[i].borderColor : datasets[0].backgroundColor[i],
                          chart.config.type === "line" ? datasets[i].label : data.labels[i]]);
              }

              /* loop through data to generate html */
              for (var i=0 ; i < dataLength; ++i) {
                  text.push('<li><span style="background-color:' + (getData(i)[0]) + '"></span>');
                  text.push(getData(i)[1]);
                  text.push('</li>');
              }

              text.push('</ul>');
              return text.join('');
          }

      }

      /* Plugin for piechart */
      var piePlugin = {
          beforeDraw: function(chart) {
              var width = chart.chart.width,
                  height = chart.chart.height,
                  ctx = chart.chart.ctx,
                  p=0;
              chart.data.datasets[0].data.map(function (t) {
                  if(typeof t === 'number' && !isNaN(t)){
                      p+=t;
                  }
              });

              ctx.restore();
              var fontSize = (height / 114).toFixed(2);
              ctx.font = fontSize + "em Quicksand";
              ctx.textBaseline = "middle";

              var text = p+' Visit',
                  textX = Math.round((width - ctx.measureText(text).width) / 2),
                  textY = height / 2;

              ctx.fillText(text, textX, textY);
              ctx.save();
          }
      };


      /* sale view statistics line chart */

      if($('#myChart').length){
          var ctx = $('#myChart');
          var chart = new Chart(ctx, {
              // The type of chart we want to create
              type: 'line',

              // The data for our dataset
              data: {
                  labels: [5,10,15,20,25,30],
                  datasets: [
                      {
                          label: "Daily Views",
                          backgroundColor: 'rgba(115, 71, 193,.5)',
                          borderColor: '#7347c1',
                          data: [5,17,13,23,18,16],
                          pointBackgroundColor: '#7347c1',
                          pointBorderColor: '#fff'
                      },
                      {
                          label: "Daily Sale",
                          backgroundColor: 'rgba(5, 116, 236,.5)',
                          borderColor: '#0674ec',
                          data: [10,12,17,19,15,9],
                          pointBackgroundColor: '#0674ec',
                          pointBorderColor: '#fff'
                      }]
              },

              // Configuration options go here
              options: {
                  scales:{
                      yAxes: [{
                          display: true,
                          ticks: {
                              beginAtZero: true,
                              suggestedMax: 40,
                              fontColor: ctxTickColor
                          }
                      }]
                  },
                  legend: {
                      display: false
                  },
                  legendCallback: customLegend
              }
          });
          /* genereate legend for sale view chart */
          var legendSale = chart.generateLegend();
          $('#stat_legend').html(legendSale);
      }





      /* visit statistics pie chart */
      if($('#piechart').length){
          var piechart = $('#piechart');
          var part  = new Chart(piechart, {
              type: 'doughnut',
              plugins: [piePlugin],
              data:{
                  datasets: [{
                      data: [120,90,70],
                      backgroundColor: [
                          '#0674ec',
                          '#ff6a6c',
                          '#61d039'
                      ]
                  }],
                  labels: [
                      "Google",
                      "Website",
                      "Other"
                  ]
              },
              options:{
                  cutoutPercentage: 75,
                  responsive: true,
                  legend: {
                      display: false
                  },
                  legendCallback: customLegend
              }
          });
          /* genereate legend for visitor pie chart */
          var legend = part.generateLegend();
          $('#pie-legend').html(legend);
      }


      /* single item view statistics */
      if($('#single_item_visit').length){
          var item_view = $('#single_item_visit');
          var viewBar = new Chart(item_view, {
              type: 'bar',

              data: {
                  labels: [3,6,9,12,15,18,21,24,27,30],
                  datasets: [
                      {
                          data:[15,14,23,48,55,25,82,33,55,41,2],
                          backgroundColor: '#0674ec'
                      }
                  ]
              },

              options: {
                  scales:{
                      yAxes: [{
                          ticks:{
                              beginAtZero: true,
                              suggestedMax: 60
                          }
                      }],
                      xAxes: [{
                          barThickness: 40
                      }]
                  },
                  legend:{
                      display: false
                  }
              }
          });
      }


      /* revenue chart */
      if($('#revenue').length){
          var revenue = $('#revenue');
          var reveChart = new Chart(revenue, {
              type: 'line',

              data: {
                  labels: months,
                  datasets:[
                      {
                          label: "2015",
                          data: [3,2.9,2.7,3.5,4,3.8,3.7,3.5,4,4.5,4.3,4.2],
                          fill: false,
                          borderColor: '#7347c1',
                          lineTension: 0,
                          pointBorderColor: '#7347c1'
                      },
                      {
                          label: "2016",
                          data: [4,3.9,3.7,4.5,5,5.8,5.1,4.5,5.7,7,6.25,5.9],
                          fill: false,
                          borderColor: '#0674ec',
                          lineTension: 0,
                          pointBorderColor: '#0674ec'
                      },
                      {
                          label: "2019",
                          data: [5,5.5,5.9,5.5,5,4.8,5.8,6.5,6.1,5.8,6.7,7.2],
                          fill: false,
                          borderColor: '#62d03a',
                          lineTension: 0,
                          pointBorderColor: '#62d03a'
                      }
                  ]
              },

              options: {
                  legend: {
                      display: false
                  },
                  legendCallback: customLegend,
                  scales: {
                      yAxes: [{
                          ticks: {
                              suggestedMax: 10,
                              callback: function (value, index, values) {
                                  return value+'k';
                              }
                          }
                      }]
                  },
                  elements:{
                      point:{
                          backgroundColor: '#fff',
                          borderWidth: 3
                      }
                  }
              }
          });
          /* generate revenue chart lagend */
          var visitLegend = reveChart.generateLegend();
          $('#visit_legend').html(visitLegend);
      }


})(jQuery);
(function ($) {
    "use strict";

    var windowWidth = $(window).width();
    var windowHeight = $(window).height();

    // custom nav trigger function for owl casousel
    function customTrigger(slideNext, slidePrev, targetSlider) {
        $(slideNext).on('click', function () {
            targetSlider.trigger('next.owl.carousel');
        });
        $(slidePrev).on('click', function () {
            targetSlider.trigger('prev.owl.carousel');
        });
    }

    /* MOBILE MENU JS*/
    function mobileMenu(triggerElem, dropdown) {
        var $dropDownTrigger = $(triggerElem + ' > a');

        $dropDownTrigger.append('<span class="lnr lnr-plus-circle"></span>');
        $dropDownTrigger.on('click', function (e) {
            e.preventDefault();
            $(this).parents(triggerElem).find(dropdown).slideToggle().parents(triggerElem).siblings().find(dropdown).slideUp();
        });
    }

    if (windowWidth < 767) {
        mobileMenu('.has_dropdown', '.dropdowns');
        mobileMenu('.has_megamenu', '.dropdown_megamenu');
    }


    $('body').scrollspy({ target: '#for_mobile' });


    /* offcanvas menu */
    $('.close_menu').on('click', function () {
        $(this).parent('.offcanvas-menu').addClass('closed');
    });

    /* filter menu reveal on click*/
    // $('.filter__menu_icon').on('click', function () {
    //     $('.filter_dropdown').toggleClass('active');
    // });

    /**/
    $('.menu_icon').on('click', function () {
        $(this).siblings('.offcanvas-menu').removeClass('closed');
    });

    // Click event to scroll to top
    var scrollTop = $('.go_top');
    scrollTop.on('click', function () {
        $('html, body').animate({ scrollTop: 0 }, 800);
        return false;
    });


    //  for mobile
    if (windowWidth <= 991) {
        var $slideNav = $('#for_mobile .nav');
        $slideNav.slideUp();
        $('.navbar-toggle').on('click', function () {
            $slideNav.slideToggle();
        })
    }


    /* setting background images */
    $('.bg_image_holder').each(function () {
        var $this = $(this);
        var imgLink = $this.children().attr('src');
        $this.css({
            "background-image": "url(" + imgLink + ")",
            "opacity": "1"
        }).children().attr('alt', imgLink);
    });

    /*COUNTER UP*/
    $('.count').counterUp({
        delay: 10,
        time: 1500
    });


    // jquery ui range
    var $priceFrom = $('.price-ranges .from'),
        $priceTo = $('.price-ranges .to');

    $(".price-range").slider({
        range: true,
        min: 0,
        max: 500,
        values: [30, 300],
        slide: function (event, ui) {
            $priceFrom.text("$" + ui.values[0]);
            $priceTo.text("$" + ui.values[1]);
        }
    });

    /* preloader js */
    $(window).load(function () {
        $('.preloader_inner').fadeOut(1000);
        $('.preloader-bg').delay('500').fadeOut(1000);
        $("body").removeClass("preload");
    });

    /* Reply comment area js goes here */
    var $replyForm = $('.reply-comment'),
        $replylink = $('.reply-link');

    $replyForm.hide();
    $replylink.on('click', function (e) {
        e.preventDefault();
        $(this).parents('.media').siblings('.reply-comment').toggle().find('textarea').focus();
    });

    /* COUNTDOWN INIT */
    $('.countdown').countdown('2020/11/25', function (event) {
        var $this = $(this).html(event.strftime(''
            + '<li>%D <span>days</span></li>  '
            + '<li>%H <span>hours</span></li>  '
            + '<li>%M <span>minutes</span></li>  '
            + '<li>%S <span>seconds</span></li> '));
    });


    // accordion js
    var $accordionTrigger = $('.single_acco_title a');
    $accordionTrigger.on('click', function () {
        $accordionTrigger.not(this).removeClass('active').find('.lnr').not($(this).find('.lnr')).removeClass('lnr-chevron-up').addClass('lnr-chevron-down');
        $(this).toggleClass('active').find('.lnr').toggleClass('lnr-chevron-up lnr-chevron-down');
    });


    /* date picker js */
    $('.dattaPikkara').datepicker();


    // price selection js
    var $licenseText = $('.card--pricing2 .pricing-options li p'),
        $price = $('.card--pricing2 .price h1 span');
    $licenseText.slideUp();

    $('.card--pricing2 .custom-radio label').on('click', function () {
        var $this = $(this);
        $licenseText.slideUp(200);
        $this.parents('li').find('p').slideDown(200);
        $price.text($this.data('price') + '.00');
    });


    /*removing extra margin from the last child of item description-area */
    $('.tab-content-wrapper').length ? $('#product-details').children().children().last().css({ 'margin-bottom': 0, 'padding-bottom': 0 }) : $('#product-details').children().last().css({ 'margin-bottom': 0, 'padding-bottom': 0 });


    /* ADD CREDIT PAGE JS */
    var $amount = $('.amounts ul li');
    $amount.on('click', function () {
        $(this).find('p').addClass('selected');
        $(this).siblings($amount).find('p').removeClass('selected');
        $('.selected_price').val($(this).data('price'));
    });


    /* settng files name */
    $('.attachment_field').on('change', function (e) {
        var files = e.target.files;
        var attached = $('.attached');
        for (var i = 0; files.length > i; i++) {
            attached.append('<p>' + files[i].name + '<span class="lnr lnr-cross"></span></p>');
        }
    });


    $('.vote a').on('click', function (e) {
        e.preventDefault();
        $(this).addClass('active').siblings('a').removeClass('active');
    });


    /* starring */
    var starring = $('.actions span.fa');
    starring.on('click', function () {
        $(this).toggleClass('fa-star-o fa-star');
    });


    /* remove uploaded files name when clicked on cross */
    $('.attached').on('click', 'p>span', function () {
        $(this).parent().remove();
    });


    /* followers following js */
    $('.user--following .btn').on('mouseenter', function () {
        $(this).text('unfollow');
    }).on('mouseleave', function () {
        $(this).text('following');
    });


    /* bar rating plugin installation */
    $('.give_rating').barrating({
        theme: 'fontawesome-stars'
    });


    /* custom slick slider navigation */
    function slickCustomTrigger(slider, prev, next) {
        prev.on('click', function () {
            slider.slick('slickNext');
        });
        next.on('click', function () {
            slider.slick('slickPrev');
        });
    }


    /* featured product slider */
    var $featuredProd = $('.prod-slider1');
    $featuredProd.owlCarousel({
        items: 1,
        autoplay: false,
        autoplaySpeed: 1000

    });
    customTrigger('.product__slider-nav .nav_right', '.product__slider-nav .nav_left', $featuredProd);


    var $featuredProd2 = $('.prod-slider2');
    $featuredProd2.owlCarousel({
        items: 1,
        autoplay: false
    });
    customTrigger('.prod_slide_prev', '.prod_slide_next', $featuredProd2);


    $('.testimonial-slider').slick({
        infinite: true,
        slidesToShow: 2,
        slidesToScroll: 1,
        prevArrow: '<span class="lnr lnr-chevron-left"></span>',
        nextArrow: '<span class="lnr lnr-chevron-right"></span>',
        responsive: [
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    infinite: true
                }
            }
        ]
    });


    /* newest product slider */
    var productSlider = $('.product_slider');
    productSlider.owlCarousel({
        items: 3,
        margin: 30,
        responsive: {
            0: {
                items: 1
            },
            768: {
                items: 2
            },
            992: {
                items: 3
            }
        }
    });

    /* follow feed slider */
    customTrigger('.follow_feed_nav .nav_right', '.follow_feed_nav .nav_left', productSlider);


    /* partners slider */
    $('.partners').owlCarousel({
        items: 5,
        autoplay: true,
        responsive: {
            0: {
                items: 1
            },
            480: {
                items: 2
            },
            768: {
                items: 3
            },
            992: {
                items: 5
            }
        }
    });


    /* sponsors slider */
    $('.sponsores').owlCarousel({
        items: 4,
        autoplay: true,
        margin: 30,
        responsive: {
            0: {
                items: 1
            },
            480: {
                items: 2
            },
            768: {
                items: 3
            },
            992: {
                items: 4
            }
        }
    });


    // this is product preview slider
    $('.item__preview-slider').slick({
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        fade: true,
        asNavFor: '.thumb-slider'
    });

    var thumbSlider = $('.thumb-slider');
    thumbSlider.slick({
        slidesToShow: 5,
        slidesToScroll: 1,
        arrows: false,
        focusOnSelect: false,
        asNavFor: '.item__preview-slider',
        responsive: [
            {
                breakpoint: 479,
                settings: {
                    slidesToShow: 3
                }
            }
        ]
    });

    // assign custom trigger for thubmSlider
    slickCustomTrigger(thumbSlider, $('.thumb-nav .nav-left'), $('.thumb-nav .nav-right'));


    /* trumbowyg init*/
    var trmbg_container = $('#trumbowyg-demo');
    if (trmbg_container.length) {
        trmbg_container.trumbowyg();
    }


    /* bootstrap tooltip activation */
    $('[data-toggle="tooltip"]').tooltip();

    /*
     * Replace all SVG images with inline SVG
     */
    $('img.svg').each(function () {
        var $img = $(this);
        var imgID = $img.attr('id');
        var imgClass = $img.attr('class');
        var imgURL = $img.attr('src');

        $.get(imgURL, function (data) {
            // Get the SVG tag, ignore the rest
            var $svg = jQuery(data).find('svg');

            // Add replaced image's ID to the new SVG
            if (typeof imgID !== 'undefined') {
                $svg = $svg.attr('id', imgID);
            }
            // Add replaced image's classes to the new SVG
            if (typeof imgClass !== 'undefined') {
                $svg = $svg.attr('class', imgClass + ' replaced-svg');
            }

            // Remove any invalid XML tags as per http://validator.w3.org
            $svg = $svg.removeAttr('xmlns:a');

            // Replace image with new SVG
            $img.replaceWith($svg);

        }, 'xml');
    });
})(jQuery);
(function () {
  "use strict";

  var myCenter = new google.maps.LatLng(54.085533, -0.194593);
  function initialize() {
    var mapProp = {
      center: myCenter,
      zoom: 16,
      scrollwheel: false,
      mapTypeId: google.maps.MapTypeId.ROADMAP,
      styles: [{ "featureType": "water", "elementType": "geometry", "stylers": [{ "color": "#e9e9e9" }, { "lightness": 17 }] },
      { "featureType": "landscape", "elementType": "geometry", "stylers": [{ "color": "#f5f5f5" }, { "lightness": 20 }] },
      { "featureType": "road.highway", "elementType": "geometry.fill", "stylers": [{ "color": "#ffffff" }, { "lightness": 17 }] },
      { "featureType": "road.highway", "elementType": "geometry.stroke", "stylers": [{ "color": "#ffffff" }, { "lightness": 29 }, { "weight": 0.2 }] },
      { "featureType": "road.arterial", "elementType": "geometry", "stylers": [{ "color": "#ffffff" }, { "lightness": 18 }] },
      { "featureType": "road.local", "elementType": "geometry", "stylers": [{ "color": "#ffffff" }, { "lightness": 16 }] },
      { "featureType": "poi", "elementType": "geometry", "stylers": [{ "color": "#f5f5f5" }, { "lightness": 21 }] },
      { "featureType": "poi.park", "elementType": "geometry", "stylers": [{ "color": "#dedede" }, { "lightness": 21 }] },
      { "elementType": "labels.text.stroke", "stylers": [{ "visibility": "on" }, { "color": "#ffffff" }, { "lightness": 16 }] },
      { "elementType": "labels.text.fill", "stylers": [{ "saturation": 36 }, { "color": "#333333" }, { "lightness": 40 }] },
      { "elementType": "labels.icon", "stylers": [{ "visibility": "off" }] },
      { "featureType": "transit", "elementType": "geometry", "stylers": [{ "color": "#f2f2f2" }, { "lightness": 19 }] },
      { "featureType": "administrative", "elementType": "geometry.fill", "stylers": [{ "color": "#fefefe" }, { "lightness": 20 }] },
      { "featureType": "administrative", "elementType": "geometry.stroke", "stylers": [{ "color": "#fefefe" }, { "lightness": 17 }, { "weight": 1.2 }] }]
    };

    var map = new google.maps.Map(document.getElementById("map"), mapProp);

    var marker = new google.maps.Marker({
      position: myCenter,
      icon: 'images/map-marker.png'
    });

    var infowindow = new google.maps.InfoWindow({
      content: "united-states"
    });

    marker.setMap(map);
  }

  google.maps.event.addDomListener(window, 'load', initialize);
})();